/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   MotoTronSpecific Security
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Dependants  :   MotoTronProtocol Archive
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file MotoSecurityItf.h
    \brief This module handles the security functions for Woodward Product. */

#ifndef __MOTOSECURITYITF_H
#define __MOTOSECURITYITF_H

/*---- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <ProtocolArchive.h>

/*---- DEFINES --------------------------------------------------------------------------------------------*/

/*---- TYPEDEF --------------------------------------------------------------------------------------------*/
#pragma pack(1)

/*! \enum E_MotoTronProductID
    \internal
    \brief The valid list of applicable Woodward product IDs.       */     
/*! \enum E_MotoTronProductID::PRODUCTID_NONE	  Reserved 			*/
/*! \enum E_MotoTronProductID::PRODUCTID_TESTCODE TestCode/MotoHawk */
/*! \enum E_MotoTronProductID::PRODUCTID_5320_MR  5320 MR     		*/
/*! \enum E_MotoTronProductID::PRODUCTID_9871_MO  9871 MO   		*/	
/*! \enum E_MotoTronProductID::PRODUCTID_9872_MC  9872 MC   		*/	
/*! \enum E_MotoTronProductID::PRODUCTID_6411_KG  6411 KG   		*/	
/*! \enum E_MotoTronProductID::PRODUCTID_7600_WI  7600 WI   		*/	
/*! \enum E_MotoTronProductID::PRODUCTID_7601_HD  7601 HD   		*/	
/*! \enum E_MotoTronProductID::PRODUCTID_3488_EB  3488 EB   		*/	
/*! \enum E_MotoTronProductID::PRODUCTID_6477_BF  6477 BF   		*/	
/*! \enum E_MotoTronProductID::PRODUCTID_1765_IN  1765 IN   		*/	
/*! \enum E_MotoTronProductID::PRODUCTID_0224_L4  0224 L4   		*/	
/* Name: E_MotoTronProductID ClassID:ENUMDEC EnumDflt:"Undefined" */
typedef enum
{
	PRODUCTID_NONE,			/* EnumTxt:"Reserved" 			*/
	PRODUCTID_TESTCODE,	    /* EnumTxt:"TestCode/MotoHawk"  */
	PRODUCTID_5320_MR,	    /* EnumTxt:"5320 MR"     		*/
	PRODUCTID_9871_MO,	    /* EnumTxt:"9871 MO"   			*/
	PRODUCTID_9872_MC,	    /* EnumTxt:"9872 MC"   			*/
	PRODUCTID_6411_KG,		/* EnumTxt:"6411 KG"   			*/
	PRODUCTID_7600_WI,	    /* EnumTxt:"7600 WI"   			*/
	PRODUCTID_7601_HD,	    /* EnumTxt:"7601 HD"   			*/
	PRODUCTID_3488_EB,	    /* EnumTxt:"3488 EB"   			*/
	PRODUCTID_6477_BF,		/* EnumTxt:"6477 BF"   			*/
	PRODUCTID_1765_IN,		/* EnumTxt:"1765 IN"   			*/
	PRODUCTID_0224_L4,		/* EnumTxt:"0224 L4"   			*/
	NUM_PRODUCT_IDS
} E_MotoTronProductID;

/*! \enum E_ProjectID
    \internal
    \brief The valid list of applicable Woodward project IDs.  */     
/*! \enum E_ProjectID::PROJECTID_MPC555  MPC555               */
/*! \enum E_ProjectID::PROJECTID_MR27    MR27                 */
/*! \enum E_ProjectID::PROJECTID_MC41    MC41                 */
/*! \enum E_ProjectID::PROJECTID_DEMO    Demo                 */	
/*! \enum E_ProjectID::PROJECTID_HCS12   HCS12                */	
/* Name: E_ProjectID ClassID:ENUMDEC EnumDflt:"Undefined" */
typedef enum
{
    PROJECTID_MPC555 = 6,  /* EnumTxt:"MPC555" */
    PROJECTID_MR27   = 27, /* EnumTxt:"MR27" */
    PROJECTID_MC41   = 41, /* EnumTxt:"MC41" */
    PROJECTID_DEMO   = 43, /* EnumTxt:"Demo" */
    PROJECTID_HCS12  = 100 /* EnumTxt:"HCS12" */
} E_ProjectID;
#define NUM_PROJECT_IDS 5

typedef struct
{
    E_AccessLevel eAccessLevel;
    E_Protocols eProtocol;
    uint4* pu4SeedAndResult;
    E_ProjectID eProjectID;
    E_MotoTronProductID eProductID;
}S_ClientMotoSecurity;

#pragma pack()
/*---- FUNCTION PROTOTYPES --------------------------------------------------------------------------------*/
NativeBool MotoSecurity32Function(E_AccessLevel in_eSwitchToAccessLevel, E_Protocols in_eSwitchToProtocol, uint4 *inout_pu4SeedAndResult);
NativeBool CanKingAuthoritySecurityFunction(uint1 in_u1RequestAuthority, uint4 *inout_pu4SeedAndResult);
void ComputeSecurityChallenge(uint4 *inout_pu4SeedAndResult, uint4 in_u4Seed, uint4 in_u4Key);

E_ProjectID GetProjectID(void);
uint4 GetProductID(void);

NativeBool ClientMotoSecurity32Function(S_ClientMotoSecurity* const in_pClientMotoSecurityObj);

#endif /* __MOTOSECURITYITF_H */

/*---- END OF FILE ----------------------------------------------------------------------------------------*/

